/*
 * Decompiled with CFR 0.152.
 */
package frc.util;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;

public class ExFileLock {
    private static final boolean TRACE = false;
    private boolean deleteTarget;
    private File targetFile;
    private RandomAccessFile accessFile;
    private FileLock lock;
    private State state = State.UNLOCKED;

    public ExFileLock(File file) {
        this.targetFile = file;
    }

    public String toString() {
        return "[LOCK-" + Integer.toString(this.hashCode(), 36).toUpperCase() + "]";
    }

    public boolean ownsLock() {
        return this.lock != null;
    }

    public boolean createdNewLock() {
        return State.GOT_NEW_LOCK == this.state;
    }

    public boolean reusedOldLock() {
        return State.GOT_OLD_LOCK == this.state;
    }

    public boolean lock() {
        if (State.UNLOCKED != this.state) {
            throw new IllegalStateException("lock()/unlock() mismatch");
        }
        boolean bl = this.targetFile.isFile();
        try {
            this.deleteTarget = false;
            this.accessFile = new RandomAccessFile(this.targetFile, "rw");
            this.deleteTarget = !bl;
            this.lock = this.accessFile.getChannel().tryLock();
        }
        catch (Exception exception) {
            this.unlock();
            this.state = State.CANNOT_LOCK;
            return false;
        }
        if (this.lock == null) {
            this.unlock();
            this.state = State.CANNOT_LOCK;
            return false;
        }
        this.state = bl ? State.GOT_OLD_LOCK : State.GOT_NEW_LOCK;
        this.deleteTarget = true;
        return true;
    }

    public void unlock() {
        if (this.ownsLock()) {
            try {
                this.lock.release();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
            this.lock = null;
        }
        if (this.accessFile != null) {
            try {
                this.accessFile.close();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
            this.accessFile = null;
        }
        if (this.deleteTarget && this.targetFile.isFile() && !this.targetFile.delete()) {
            this.targetFile.deleteOnExit();
        }
        this.state = State.UNLOCKED;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        UNLOCKED,
        GOT_NEW_LOCK,
        GOT_OLD_LOCK,
        CANNOT_LOCK;

    }
}

